set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517426';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2322',
      NULL,
      29.174529,
      55,
      '2240232',
      148.129986,
      2,
      3,
      1,
      '221034',
      1,
      ' 8-13-1974',
      NULL,
      0.498245,
      1,
      NULL,
      0.398934,
      1.306798,
      3,
      0.775305,
      1,
      0,
      1.409712,
      0,
      1,
      1.211332,
      4,
      1.516230,
      NULL,
      NULL,
      0,
      1.657443,
      2.567724,
      0,
      0.179150,
      0.339896,
      3,
      1,
      2,
      NULL,
      2.293746,
      2.813163,
      0,
      0.235595,
      NULL,
      NULL,
      0.374611,
      NULL,
      NULL,
      6.064474,
      2.613915,
      NULL,
      2,
      1.922093,
      1,
      NULL,
      3.259770,
      2.367600,
      1.045421,
      3,
      1,
      1.464592,
      NULL,
      1,
      2,
      0,
      1,
      3,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.663814,
      NULL,
      1,
      0.579150,
      NULL,
      0.381957,
      0,
      0.659127,
      0,
      0.296674,
      0.076777,
      3,
      1,
      0.693037,
      0,
      0.841844,
      1,
      NULL,
      0.318613,
      0.745982,
      1.632747,
      5.220656,
      1.667751,
      0.055253,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.401508,
      NULL,
      0.414557,
      1,
      3.441359,
      3,
      2,
      3,
      9,
      0.913401,
      8.569752,
      NULL,
      1,
      1.854294,
      4,
      0,
      3,
      NULL,
      NULL,
      1,
      0.956884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281509,
      1,
      0,
      1,
      1.375536,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.639518,
      0.992117,
      2.933937,
      0,
      0,
      0.781405,
      7.635207,
      0,
      NULL,
      5.250216,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.397056,
      1.570422,
      2.016648,
      1.172099,
      2,
      1.461281,
      NULL,
      0.637160,
      2,
      2.282995,
      NULL,
      0,
      0.032796,
      0,
      0,
      0,
      0.479459,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '14330',
      NULL,
      '',
      0.594546,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.628819,
      2.493708,
      1.838134);
commit;
end;
/


