set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '4031420',
      0.792537,
      4,
      0,
      NULL,
      '443431',
      2.326582,
      '10- 3-1982',
      36.360331,
      NULL,
      1,
      NULL,
      1,
      0,
      2,
      0.297678,
      0.640660,
      0.179560,
      0,
      3.629609,
      NULL,
      1.567260,
      NULL,
      0,
      1.032973,
      NULL,
      1.778955,
      0,
      0,
      1.375253,
      NULL,
      1.795677,
      NULL,
      0.296374,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.128874,
      NULL,
      3,
      0.264423,
      0.598277,
      2,
      0,
      2,
      1,
      1,
      0,
      1.514480,
      1.260744,
      1,
      3,
      1.778169,
      3,
      2,
      0.529522,
      1,
      1.757995,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.831705,
      0,
      NULL,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      1,
      1,
      0.196209,
      0,
      1.549775,
      0.498677,
      1,
      0.850337,
      0.216902,
      NULL,
      0,
      NULL,
      1,
      1,
      0.590732,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.446627,
      NULL,
      0,
      5.423882,
      NULL,
      5,
      NULL,
      4,
      NULL,
      7.081850,
      1,
      5.675453,
      NULL,
      0.146516,
      1.031817,
      NULL,
      NULL,
      3,
      0.821713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.885127,
      1.036219,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.992479,
      NULL,
      1.946499,
      2.340020,
      NULL,
      0.311641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936087,
      1.148312,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.255652,
      0.450594,
      0,
      2,
      0.999003,
      NULL,
      NULL,
      NULL,
      0,
      2.811211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.745729,
      1,
      NULL,
      NULL,
      1,
      0,
      0.640850,
      1,
      1.692949,
      0,
      1.582023,
      0.774506,
      0.398507,
      1.789943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '43124',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


