set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '3104131',
      18,
      3,
      NULL,
      1,
      '022330',
      1.720293,
      NULL,
      19.922157,
      NULL,
      0.265520,
      NULL,
      1,
      1.141331,
      3,
      0.392662,
      0,
      NULL,
      0,
      2,
      NULL,
      1.889284,
      0.734100,
      0.682246,
      1.910755,
      1.779576,
      0,
      0,
      1.918396,
      1.252634,
      1.356001,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216195,
      1,
      0.855303,
      1.529731,
      0.391413,
      0.128265,
      0.000134,
      NULL,
      1.779604,
      0.643710,
      0,
      0.649664,
      0,
      NULL,
      0,
      0,
      3.841779,
      1.872923,
      0.644134,
      NULL,
      0,
      1,
      0,
      0,
      2.936763,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410757,
      0,
      NULL,
      NULL,
      NULL,
      1.694151,
      0,
      0.306391,
      0,
      0,
      0,
      0.120971,
      0.258916,
      1.789350,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.971397,
      0.577838,
      NULL,
      1.596286,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.734570,
      0.097379,
      1,
      1.275405,
      NULL,
      5.425526,
      NULL,
      NULL,
      4,
      0,
      0.059142,
      3.268382,
      0,
      0.246006,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.306462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.286388,
      1,
      NULL,
      0.259709,
      0.699605,
      1,
      0.601770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188681,
      NULL,
      6,
      NULL,
      0,
      1.631814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.835695,
      1.730878,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283519,
      1.751057,
      0.266409,
      0,
      1.265347,
      0,
      0.727272,
      NULL,
      NULL,
      NULL,
      1,
      2.160905,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.766311,
      2,
      1.281721,
      1.284802,
      NULL,
      1.606417,
      0.206296,
      NULL,
      1.546646,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1.387095,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.105007,
      '42112',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


