set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '200',
      NULL,
      10,
      10.928187,
      '2133211',
      16,
      NULL,
      2,
      1,
      '013322',
      4,
      ' 3- 9-1999',
      56,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033213,
      3,
      0.555650,
      1,
      0.706681,
      0.021927,
      NULL,
      NULL,
      0.644945,
      NULL,
      1.585981,
      1,
      1,
      0,
      0.780260,
      2.042474,
      NULL,
      1.174909,
      1,
      1,
      0,
      NULL,
      0,
      3.880323,
      1,
      0,
      1.302894,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.420499,
      NULL,
      NULL,
      NULL,
      1.694241,
      0,
      2.561023,
      1.538124,
      3.626582,
      0,
      1,
      0.805866,
      1.595152,
      1.806820,
      3.428353,
      2,
      0.306198,
      2,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376750,
      0,
      0.032813,
      NULL,
      NULL,
      1,
      0.702689,
      1.530771,
      0,
      NULL,
      0,
      1.756505,
      1.088648,
      1,
      1.792782,
      1.481584,
      1.345870,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.502809,
      NULL,
      0.059856,
      NULL,
      1,
      3.242569,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.346227,
      5.142943,
      0,
      NULL,
      NULL,
      1.850000,
      NULL,
      4.469876,
      0,
      4.210523,
      NULL,
      8.791035,
      0,
      NULL,
      3.553258,
      1.368976,
      NULL,
      NULL,
      7.731035,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152145,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.767774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.531290,
      NULL,
      4.723617,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067888,
      1.532426,
      3,
      NULL,
      NULL,
      1.664508,
      NULL,
      0,
      3.347608,
      0.560344,
      0,
      1,
      NULL,
      1,
      0,
      1,
      0.317380,
      NULL,
      0.469961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '24241',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.444124,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


