set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '14',
      0.465510,
      13.500455,
      '0424411',
      36.988281,
      3,
      0.753500,
      NULL,
      '133024',
      3,
      ' 6-29-1975',
      27.673063,
      13,
      0.216343,
      NULL,
      0,
      0,
      3,
      1,
      0,
      NULL,
      0.861487,
      NULL,
      1,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      5,
      NULL,
      1.850885,
      0.538511,
      3.670469,
      NULL,
      2,
      0.752596,
      1.253140,
      NULL,
      NULL,
      NULL,
      0.926821,
      NULL,
      NULL,
      0.757489,
      0.825975,
      1,
      3.922511,
      1.870066,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.596642,
      1,
      1,
      1.719808,
      2,
      NULL,
      1.405686,
      2,
      1,
      0,
      NULL,
      4.665521,
      0,
      1,
      1.766262,
      0.281829,
      NULL,
      NULL,
      0.171879,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238393,
      0,
      0.581663,
      1,
      1,
      1,
      0.350463,
      1.794918,
      1,
      NULL,
      1,
      0.397749,
      NULL,
      1,
      0.687408,
      1,
      NULL,
      NULL,
      NULL,
      1.166281,
      1,
      0.524974,
      0.826967,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.196779,
      NULL,
      5,
      1.440700,
      1.662275,
      3.990973,
      1,
      2.570505,
      0.946401,
      1,
      2.442080,
      5.776052,
      NULL,
      5,
      1,
      0.091705,
      0.589924,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725766,
      0,
      1,
      1.556856,
      1.704502,
      1.541768,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8,
      1,
      0.591726,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920293,
      2.742034,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634956,
      NULL,
      6.821525,
      3.720489,
      4,
      0,
      0.105366,
      NULL,
      NULL,
      NULL,
      1.554590,
      0.843850,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472164,
      2.328862,
      2,
      0,
      1.484665,
      0,
      0,
      0.176892,
      1,
      0.376659,
      1.907876,
      0.001300,
      1,
      0.019637,
      0.371165,
      1.670829,
      1,
      NULL,
      0,
      1.579424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '04112',
      '',
      '',
      1.819921,
      NULL,
      '',
      '',
      0.353071,
      '',
      '',
      NULL,
      5.680904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


