set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '42',
      43.003527,
      7.696949,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '232001',
      4,
      ' 9- 1-1992',
      18.046366,
      20,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.611107,
      1,
      1,
      NULL,
      1,
      1,
      3.312650,
      1.765513,
      5,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      3,
      NULL,
      4,
      1,
      2.775230,
      0,
      0.986335,
      0.521150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.761030,
      3.580283,
      0.764023,
      0,
      2.811471,
      1.932656,
      2,
      0,
      1,
      0.585835,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1.736933,
      1.737298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701655,
      1,
      NULL,
      1.726916,
      1,
      1.228282,
      1.780832,
      0.215183,
      1.382932,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1.722007,
      0,
      0.427205,
      1.480331,
      1.403639,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.248368,
      5.652883,
      0.931242,
      1.035386,
      1.719048,
      3.050879,
      9.539904,
      7,
      4,
      9,
      2.160438,
      5,
      6.770410,
      1,
      1.291811,
      4,
      0.960301,
      NULL,
      NULL,
      1.831232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1.605426,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      0,
      0,
      1.461713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433568,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      6,
      1,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.988212,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850687,
      2,
      NULL,
      1,
      NULL,
      1,
      1.487986,
      1.847521,
      1.608077,
      1.883552,
      1.446722,
      0.930915,
      1,
      NULL,
      0.135388,
      1,
      1,
      1.980151,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '20402',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      3.733620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


