set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      '42',
      NULL,
      4,
      '0110344',
      58.631346,
      3,
      2,
      2,
      '043340',
      NULL,
      NULL,
      13.891967,
      68,
      0.515544,
      NULL,
      1.541308,
      1.839746,
      3.198856,
      0,
      NULL,
      1.225683,
      NULL,
      NULL,
      1.782930,
      0,
      NULL,
      NULL,
      3.748659,
      1,
      1.042264,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      2.958048,
      0,
      2.556471,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.295528,
      NULL,
      NULL,
      5,
      NULL,
      0.742527,
      2.860548,
      0.960617,
      0.065993,
      3,
      1,
      1.957973,
      0,
      0,
      1.024392,
      1.064225,
      0,
      2,
      2.846762,
      0.528138,
      1,
      2.572308,
      1.265210,
      0.958180,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.347193,
      1,
      0.096524,
      0.644043,
      0,
      0,
      0.221741,
      1,
      NULL,
      1.956689,
      0,
      1.047235,
      NULL,
      0.237079,
      1.456557,
      1.193066,
      0,
      0,
      NULL,
      1.327794,
      1.008519,
      1,
      NULL,
      NULL,
      1.508740,
      0.318287,
      1.643322,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.954683,
      0.205155,
      7.841647,
      2,
      3.740900,
      5.050796,
      5.471493,
      3,
      NULL,
      NULL,
      NULL,
      0.083599,
      2.200699,
      0,
      NULL,
      NULL,
      NULL,
      1.387209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331087,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8,
      0.704211,
      0,
      1.694692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2.092140,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408595,
      NULL,
      3.943418,
      3.072670,
      2,
      1.750977,
      NULL,
      NULL,
      NULL,
      0,
      2.759228,
      1.633034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.581708,
      0,
      1,
      3,
      1,
      3.702174,
      1.945822,
      0.569488,
      0.591051,
      1.794904,
      1.098856,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '12403',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.234577,
      '',
      NULL,
      '',
      2.198128,
      1.198902,
      3.002122,
      2,
      NULL,
      NULL,
      1,
      1.840944,
      2.391838);
commit;
end;
/


