set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '11041142',
      0.140709,
      20.780966,
      '2330241',
      88,
      NULL,
      0,
      0,
      '232140',
      4.829941,
      ' 4-15-1989',
      54,
      27.455092,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      2,
      0.023824,
      0.261122,
      NULL,
      1,
      1,
      1.232407,
      1,
      1,
      NULL,
      NULL,
      0.889032,
      0,
      NULL,
      0,
      4,
      NULL,
      1.643604,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.741639,
      1,
      3,
      NULL,
      1,
      0.212681,
      1.680216,
      2.130069,
      1,
      0.796737,
      1,
      NULL,
      0,
      0.671563,
      0,
      0,
      0,
      2,
      1.817479,
      NULL,
      1.241724,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      1.369062,
      NULL,
      NULL,
      0,
      1.247622,
      0.514888,
      1.452918,
      0,
      0,
      1.597097,
      0.131837,
      0.811285,
      1,
      NULL,
      0,
      1.894249,
      NULL,
      0.494927,
      NULL,
      0,
      0.038384,
      1,
      NULL,
      1,
      NULL,
      0.695785,
      1,
      1,
      NULL,
      0.981241,
      1,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      1.649053,
      1.069895,
      8,
      7,
      3.544980,
      6.963059,
      6.215388,
      4.278932,
      NULL,
      4.401919,
      NULL,
      NULL,
      1.857796,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0.416574,
      0,
      0.492177,
      1.621603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.679068,
      1.230029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.124091,
      1.181905,
      5.151707,
      0,
      2,
      0.960689,
      NULL,
      NULL,
      NULL,
      0.659404,
      3.114821,
      1.410785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.333653,
      NULL,
      0.645813,
      0.511898,
      NULL,
      1.664141,
      2,
      NULL,
      1.383773,
      NULL,
      1,
      0,
      0.421343,
      NULL,
      NULL,
      1,
      1,
      0.512479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      '',
      1.737632,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      3,
      3,
      2.283223,
      NULL,
      0,
      3.297422,
      2.827871,
      3.854913);
commit;
end;
/


