set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      50.567560,
      42,
      '3211030',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.994299,
      ' 9-20-1982',
      NULL,
      51.835951,
      1.319756,
      NULL,
      NULL,
      1,
      0.249424,
      NULL,
      1,
      0.130145,
      0.791777,
      NULL,
      1,
      1,
      0.804657,
      0.761086,
      1,
      0,
      NULL,
      NULL,
      4.414867,
      1.100468,
      NULL,
      0,
      NULL,
      0.419339,
      2.204965,
      NULL,
      1.331109,
      0,
      0,
      1.652496,
      NULL,
      NULL,
      1.821845,
      NULL,
      NULL,
      5,
      3.009838,
      0,
      2.852020,
      0,
      0.883455,
      2.641052,
      1,
      1,
      0.765436,
      2,
      1.751438,
      1,
      1.572919,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.886757,
      0.192573,
      0,
      4.778368,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.723597,
      NULL,
      NULL,
      0.133878,
      0,
      NULL,
      NULL,
      1,
      1,
      0.577370,
      1.432211,
      0,
      0.949712,
      0.329196,
      NULL,
      1.728355,
      1,
      1,
      1.796494,
      0.136629,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.786731,
      NULL,
      NULL,
      1,
      NULL,
      1.739038,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.352934,
      2,
      4,
      1,
      5,
      3,
      7.253596,
      7,
      1.714721,
      4.310980,
      NULL,
      5.981719,
      0.785340,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589322,
      1.688480,
      1,
      0,
      0,
      0.630890,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.668022,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.850117,
      0.841606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.680543,
      NULL,
      0.567726,
      0,
      5,
      0,
      NULL,
      NULL,
      0.544843,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025479,
      3.891288,
      0,
      1.328358,
      1.162340,
      0,
      1,
      3,
      0,
      3.981253,
      1.814806,
      0.641902,
      NULL,
      1,
      1.933873,
      1,
      NULL,
      NULL,
      1,
      0.610929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '00324',
      NULL,
      '',
      1.160863,
      '',
      '',
      NULL,
      1.435532,
      NULL,
      '',
      '',
      5,
      NULL,
      2,
      1.321952,
      0,
      1,
      0,
      1,
      3.249612);
commit;
end;
/


