set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      44,
      28.871527,
      '2213433',
      6,
      3,
      1,
      2,
      '241023',
      3.299757,
      '11- 8-1980',
      NULL,
      29,
      1,
      NULL,
      NULL,
      NULL,
      2.330584,
      1,
      1.492547,
      0,
      0,
      3,
      1.529396,
      1.973904,
      0.346425,
      0,
      1.160632,
      0,
      1.715674,
      0,
      3.291111,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.672575,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.266623,
      0.823122,
      NULL,
      0,
      1,
      1.636971,
      3.897088,
      1.360375,
      NULL,
      0.747946,
      NULL,
      0,
      1.199991,
      1,
      0,
      1.273556,
      1.744880,
      2.533428,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      1.956963,
      NULL,
      NULL,
      0.376447,
      NULL,
      NULL,
      1,
      0,
      0.795266,
      0.385869,
      0.900461,
      0,
      1.503101,
      0,
      0.922326,
      0.292224,
      0.301522,
      NULL,
      NULL,
      0.795123,
      1,
      NULL,
      0.610730,
      1.616298,
      0.135466,
      NULL,
      0.261146,
      2,
      1,
      1.795852,
      2.353490,
      0.784044,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005473,
      2.085744,
      5,
      0.343642,
      0,
      NULL,
      6.605656,
      0,
      1,
      1,
      4,
      8.260986,
      3,
      4,
      NULL,
      3.878030,
      0.327468,
      NULL,
      NULL,
      3,
      1.093232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      0,
      0.822345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.354531,
      NULL,
      7.190731,
      2.024977,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.418921,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260544,
      1.900820,
      1.454885,
      3.237526,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.027616,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.611286,
      0.793069,
      2,
      1.434264,
      2,
      3.969098,
      1.687691,
      NULL,
      0,
      0,
      0.567574,
      NULL,
      0,
      1.895756,
      NULL,
      0,
      NULL,
      0,
      0.776837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '31213',
      '',
      '',
      1,
      '',
      '',
      '',
      0.150286,
      NULL,
      NULL,
      '',
      1,
      1.070029,
      NULL,
      0,
      3.364274,
      3,
      1.826460,
      1,
      NULL);
commit;
end;
/


