set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '010',
      '42220211',
      67,
      48.322897,
      '3312143',
      62.017910,
      5,
      0,
      2,
      '431403',
      3,
      '10-24-1977',
      7,
      45.435623,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.202538,
      NULL,
      NULL,
      1.908521,
      0,
      1,
      0.430342,
      1,
      0,
      0.608466,
      0,
      NULL,
      4.331942,
      NULL,
      NULL,
      1,
      4.821930,
      1.984998,
      NULL,
      1,
      NULL,
      3.220285,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.048535,
      0.956168,
      3.967509,
      0,
      NULL,
      NULL,
      2,
      1,
      0.803188,
      0,
      1.757956,
      3,
      1.062290,
      NULL,
      3.402187,
      1.026440,
      1,
      0,
      4.279898,
      NULL,
      1,
      2.022085,
      0.285484,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.568458,
      NULL,
      NULL,
      1,
      1,
      1.282118,
      1,
      0,
      1,
      0,
      0,
      NULL,
      0.994874,
      NULL,
      NULL,
      NULL,
      0,
      3.115116,
      1,
      3.346612,
      2.370386,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.299541,
      2,
      1.782427,
      0,
      3,
      9.122298,
      6,
      7,
      5.707438,
      1,
      3,
      5,
      NULL,
      3.346979,
      7.653984,
      0,
      NULL,
      NULL,
      NULL,
      0.746910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034380,
      0,
      1,
      NULL,
      1.581888,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.926190,
      NULL,
      4.676943,
      0,
      1.695756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.008497,
      1,
      1.868201,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.123130,
      0.921259,
      0.768612,
      2,
      1.172658,
      NULL,
      NULL,
      NULL,
      NULL,
      2.579439,
      0.936295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.821061,
      NULL,
      1,
      1.538106,
      2,
      1.232717,
      3.631454,
      1,
      0,
      0,
      NULL,
      1.632212,
      0.497810,
      0,
      1,
      0,
      1.339042,
      0.029423,
      1.868595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.895561,
      '24232',
      '',
      '',
      1.272676,
      '',
      '',
      NULL,
      1.962361,
      '',
      NULL,
      '',
      NULL,
      NULL,
      1,
      1.719221,
      0.512201,
      1.792520,
      NULL,
      0.451233,
      0);
commit;
end;
/


