set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '03142420',
      10,
      50,
      '4340434',
      151.409487,
      5,
      0.673092,
      1,
      '031210',
      NULL,
      NULL,
      9.130482,
      261.891493,
      0,
      NULL,
      0.670406,
      1.847222,
      NULL,
      1.819092,
      0.835937,
      0,
      NULL,
      0,
      1,
      0.746322,
      1,
      0,
      1,
      NULL,
      1.440778,
      0.164811,
      NULL,
      1,
      1.925732,
      1,
      NULL,
      1.532362,
      4,
      0,
      1.969726,
      NULL,
      1.944413,
      1.017809,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.800391,
      3.768607,
      1.707201,
      0.631831,
      3.244330,
      0,
      NULL,
      0.031084,
      0.441746,
      0.525954,
      1.216941,
      0.199144,
      0.495057,
      2.509613,
      NULL,
      3,
      2.751110,
      1,
      0,
      NULL,
      3.689479,
      1,
      0,
      3,
      1.865123,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.202227,
      NULL,
      NULL,
      1.274025,
      1,
      0.539043,
      0.649574,
      1,
      1.096787,
      1,
      NULL,
      1,
      1,
      0.756324,
      1,
      0,
      0,
      0.222089,
      0.788751,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.644949,
      0,
      3.102378,
      2.461062,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.196721,
      0.200483,
      NULL,
      0,
      6.528110,
      NULL,
      6.215216,
      5.981634,
      5,
      0,
      5.438736,
      NULL,
      3.611406,
      1.815668,
      1,
      0.609065,
      NULL,
      NULL,
      1.075023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472153,
      0,
      0,
      1.973353,
      1.512120,
      0.199096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.681438,
      NULL,
      NULL,
      3.055107,
      1.548913,
      1.769413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.910738,
      NULL,
      NULL,
      NULL,
      0.624210,
      1.355014,
      NULL,
      4,
      NULL,
      NULL,
      0.552409,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909081,
      0,
      3,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      3.094933,
      NULL,
      1,
      1,
      1.611978,
      1.361489,
      1.956460,
      1.057310,
      0,
      0.593278,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '00422',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.350594,
      0,
      0.164219,
      1.680522,
      3,
      0.602135,
      0.007678,
      0,
      1.583267);
commit;
end;
/


