set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '34114144',
      NULL,
      56.750745,
      '2302314',
      NULL,
      6,
      3.079138,
      0,
      '040313',
      4.593410,
      '11- 4-1991',
      6.425438,
      25.778936,
      0.930205,
      NULL,
      NULL,
      1.013717,
      2,
      1,
      1.112155,
      1,
      0.975565,
      0,
      1,
      0,
      1,
      0,
      0,
      0.937425,
      0.038616,
      0.455295,
      1.152031,
      0,
      1.580386,
      1,
      1,
      0.564028,
      1,
      1,
      0.368786,
      0.133273,
      1.378724,
      0,
      NULL,
      NULL,
      0.939291,
      NULL,
      NULL,
      9,
      5.328313,
      NULL,
      3,
      NULL,
      1,
      3,
      0,
      0,
      1,
      3,
      0.315732,
      0,
      0.108865,
      0,
      0,
      NULL,
      3.131217,
      3,
      1,
      1.347280,
      1.883349,
      4,
      0,
      NULL,
      2,
      0.647677,
      NULL,
      NULL,
      0.420416,
      NULL,
      NULL,
      NULL,
      1.148440,
      1.819499,
      0,
      0,
      0,
      1.228229,
      NULL,
      0,
      1.068130,
      1,
      NULL,
      NULL,
      1,
      0.785689,
      NULL,
      NULL,
      1,
      0.871216,
      NULL,
      1.645499,
      1,
      0.057236,
      5.139508,
      1.300065,
      0.116896,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.809197,
      NULL,
      1,
      1.116963,
      NULL,
      NULL,
      2,
      4.702885,
      NULL,
      7,
      NULL,
      1.201482,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.164562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      1.264554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.970227,
      NULL,
      3,
      NULL,
      0.558419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.475960,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.444180,
      NULL,
      7.798259,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4.075800,
      1.187730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      2,
      0,
      1,
      0.395662,
      1,
      1,
      NULL,
      0,
      0.675474,
      0.573353,
      0,
      1.106707,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.533649,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.487593,
      '',
      '',
      '',
      2.079622,
      2.596032,
      NULL,
      2,
      0,
      NULL,
      1,
      0.053824,
      2.363481);
commit;
end;
/


