set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '21341012',
      0.649413,
      61.379755,
      NULL,
      125,
      4,
      0.307510,
      0,
      NULL,
      1.127712,
      ' 9- 3-1989',
      7.716377,
      48,
      1,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      1,
      NULL,
      1.143317,
      1.440742,
      1,
      3.925764,
      1,
      0.340609,
      1.789248,
      NULL,
      0.106997,
      3,
      NULL,
      1,
      1.496651,
      0,
      1.266451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.495037,
      NULL,
      0.178795,
      2.835359,
      1,
      NULL,
      0,
      0.301532,
      3.898727,
      NULL,
      2.065273,
      1,
      NULL,
      0.024428,
      NULL,
      0.340526,
      0.786010,
      1,
      1.361690,
      0,
      0.485145,
      0.163647,
      2.719096,
      NULL,
      2,
      1.801686,
      NULL,
      NULL,
      NULL,
      0.044616,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.327210,
      0,
      1,
      0.882610,
      0,
      0,
      1.045240,
      1.594385,
      0.848240,
      NULL,
      NULL,
      0.955903,
      0.836552,
      5,
      0.517461,
      NULL,
      3.349869,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.229943,
      NULL,
      0,
      0.709718,
      8,
      5,
      6,
      9,
      5.129312,
      5,
      3.898802,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1.646427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1.531777,
      1.897973,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942259,
      NULL,
      2,
      1.704723,
      0.493573,
      0.315697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      1.251941,
      NULL,
      NULL,
      NULL,
      1,
      0,
      7,
      9.832856,
      1.968301,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.671077,
      0.214575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0.296277,
      NULL,
      1,
      2.504026,
      1.606747,
      3.290153,
      0,
      1.216290,
      0.382546,
      1,
      0.313154,
      0.848767,
      NULL,
      1.877049,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '23103',
      '',
      '',
      0,
      '',
      '',
      '',
      0.749759,
      '',
      '',
      '',
      3,
      NULL,
      2,
      0,
      1,
      1,
      0.954080,
      3,
      0);
commit;
end;
/


