set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '34133134',
      NULL,
      21,
      '4411434',
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      ' 2- 6-1998',
      48,
      4,
      NULL,
      NULL,
      1.814911,
      0.263863,
      NULL,
      1.320757,
      0,
      0.073443,
      0,
      3.143217,
      0.016464,
      NULL,
      1.815919,
      NULL,
      0,
      0.000456,
      1,
      1.909734,
      0.545945,
      1.897913,
      3,
      1,
      1.327986,
      0,
      0.691595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557216,
      3,
      NULL,
      NULL,
      0.849651,
      0.458312,
      NULL,
      1,
      1,
      1.789156,
      2.406853,
      0,
      0.340860,
      1.979595,
      3,
      0,
      1,
      3.932037,
      2.217082,
      0,
      1.884388,
      1,
      5.009816,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1.876359,
      1,
      1,
      0.494741,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.017853,
      1.918737,
      0.776046,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3.631216,
      0.820126,
      1,
      0.962064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.262251,
      NULL,
      3.355935,
      0,
      0,
      9,
      2.168725,
      5,
      3,
      NULL,
      NULL,
      2,
      4.634029,
      7,
      5.615166,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880195,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.873642,
      NULL,
      2,
      2.436788,
      1,
      4.096056,
      0.883513,
      NULL,
      NULL,
      NULL,
      2,
      10.182614,
      3,
      0.896156,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3.270165,
      7,
      4.570019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733249,
      6.757136,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.767148,
      0,
      3,
      NULL,
      NULL,
      1.293613,
      1,
      3.397836,
      NULL,
      3.520614,
      0,
      1.738807,
      NULL,
      1,
      0,
      1.966634,
      1.554778,
      1.095346,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.903793,
      '43041',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.383226,
      '',
      NULL,
      '',
      4.768423,
      2.131965,
      0.646798,
      3.853783,
      2.370338,
      1.157620,
      0,
      NULL,
      NULL);
commit;
end;
/


