set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0320',
      '34410124',
      67.109709,
      NULL,
      NULL,
      NULL,
      1,
      3.951269,
      NULL,
      '242013',
      0.437736,
      ' 3-21-1989',
      44.011209,
      NULL,
      NULL,
      NULL,
      0.269066,
      2,
      0.224075,
      0,
      0,
      NULL,
      1,
      2,
      0.455261,
      0.994102,
      4.841945,
      0,
      0.170020,
      1,
      0.650075,
      0,
      0,
      1,
      0,
      0.837751,
      4,
      1,
      5,
      0,
      1.646547,
      3,
      0.573373,
      NULL,
      NULL,
      NULL,
      0.467260,
      NULL,
      NULL,
      0.002133,
      3,
      0.510588,
      2,
      0.900777,
      0.096373,
      NULL,
      1,
      1,
      1.020571,
      2,
      NULL,
      0.336507,
      1.531919,
      3,
      2.574645,
      0.289313,
      1,
      3.429516,
      NULL,
      1,
      NULL,
      3.994426,
      NULL,
      1,
      3.131853,
      1.690774,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.749438,
      NULL,
      0.921117,
      NULL,
      0.242303,
      1,
      0.979354,
      0.025168,
      1.821618,
      NULL,
      1.442175,
      0.833285,
      0,
      0.842013,
      1.085656,
      0,
      NULL,
      0.282750,
      0.433429,
      NULL,
      NULL,
      NULL,
      1.563153,
      1.954408,
      3.821262,
      NULL,
      NULL,
      0,
      3,
      1.771809,
      0.807571,
      0,
      1.541558,
      3,
      5,
      0,
      0.431308,
      3,
      3,
      8.275361,
      3.870075,
      2,
      7,
      5.682545,
      9.464116,
      NULL,
      NULL,
      6.639046,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.178273,
      1,
      0,
      1,
      0.989475,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.938088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.876481,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.168912,
      NULL,
      2,
      1,
      1,
      1.211383,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028254,
      3,
      0,
      2.208181,
      1.280436,
      0.279163,
      0,
      3.922618,
      0,
      1,
      1,
      0.594041,
      0,
      NULL,
      NULL,
      0,
      0.134185,
      NULL,
      0.622693,
      0.865642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      NULL,
      1.949139,
      '',
      '',
      '',
      0.426326,
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      3.761475,
      NULL,
      0,
      NULL);
commit;
end;
/


