set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3012',
      '42231212',
      39,
      82.274918,
      '3312130',
      182,
      6,
      3,
      1,
      '224441',
      2,
      ' 9- 9-1991',
      54.954994,
      8,
      0.450847,
      NULL,
      NULL,
      0,
      0,
      0.111850,
      1,
      NULL,
      NULL,
      2,
      1.287583,
      1,
      5,
      1,
      0.855253,
      1.630228,
      0,
      1.108787,
      NULL,
      1.268294,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.378974,
      NULL,
      NULL,
      NULL,
      0.047935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.588614,
      1.261495,
      1.258110,
      2.610656,
      0,
      1.308202,
      NULL,
      0,
      2,
      1.761522,
      3.257966,
      NULL,
      NULL,
      0,
      0.185468,
      2.356261,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.483582,
      1.220693,
      1.981897,
      0,
      1,
      NULL,
      0.365611,
      0,
      1.526545,
      0.278706,
      0.909997,
      NULL,
      0.827129,
      0.035881,
      1.800907,
      NULL,
      0.577803,
      1.258670,
      NULL,
      0,
      NULL,
      0,
      2.717559,
      3,
      NULL,
      2.312769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087692,
      6.257129,
      2.932074,
      1.642424,
      0,
      0.792052,
      NULL,
      2.524131,
      NULL,
      10,
      4.800164,
      4,
      3,
      1,
      0.582588,
      6,
      1.515130,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.096859,
      NULL,
      1,
      NULL,
      0,
      1,
      1.599345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.845019,
      0.077622,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.309611,
      0.109147,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      4.361365,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.265261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.929900,
      0,
      1.633134,
      NULL,
      0.214559,
      3.986469,
      0,
      2,
      NULL,
      1.037382,
      0,
      1.916178,
      0,
      0,
      0.540877,
      0.211634,
      0.334076,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '10014',
      '',
      '',
      0.673204,
      '',
      '',
      '',
      1.167997,
      '',
      '',
      '',
      NULL,
      2,
      0.765946,
      1.886755,
      1,
      NULL,
      3.823766,
      1,
      NULL);
commit;
end;
/


