set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0340',
      '13330214',
      49.498959,
      52,
      '1101403',
      62.816382,
      0,
      2.231843,
      1,
      '243432',
      2,
      NULL,
      49.275615,
      7.812006,
      0,
      NULL,
      NULL,
      1.400593,
      2.747885,
      0,
      0.956622,
      1,
      1,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      0,
      0,
      NULL,
      0,
      1.535513,
      NULL,
      1.527835,
      1,
      1,
      1,
      0,
      NULL,
      2,
      0,
      1.965141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.187686,
      1.622419,
      0,
      1.320474,
      3,
      1,
      0,
      0.354112,
      0,
      NULL,
      0.381054,
      NULL,
      2.141319,
      2.173059,
      0.351997,
      0,
      0.115658,
      1,
      1,
      0.575699,
      2.837484,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.891067,
      NULL,
      NULL,
      0,
      0.705644,
      1.453543,
      1,
      0,
      0,
      1.598279,
      0.944775,
      1.485113,
      0,
      0,
      0.372988,
      NULL,
      0.477529,
      1.976661,
      0,
      1.304072,
      NULL,
      0.336806,
      NULL,
      0,
      2.139382,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      4.137261,
      1,
      0.021042,
      2,
      NULL,
      0.689705,
      0.821913,
      4.868436,
      6.946921,
      5,
      0.309953,
      3.924503,
      5.124991,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.047932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.219553,
      NULL,
      NULL,
      0,
      NULL,
      1.054175,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.024871,
      NULL,
      9.782609,
      0,
      1,
      0.491225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235329,
      1,
      9,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.262658,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      0,
      1,
      2.297602,
      NULL,
      1.072279,
      2,
      0,
      1,
      1.091938,
      1.468172,
      1,
      0.778912,
      1.667881,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '30432',
      '',
      '',
      1.742106,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      1.127971,
      3.716857,
      NULL,
      2.211899,
      0.585595,
      NULL,
      1.730227,
      1.765798);
commit;
end;
/


