set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8905010';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4324',
      NULL,
      70,
      89,
      '2113412',
      89,
      5,
      2.870040,
      3,
      '333041',
      4,
      NULL,
      33,
      52.978061,
      1,
      NULL,
      0,
      1,
      2.877702,
      NULL,
      0.101640,
      NULL,
      1.596385,
      NULL,
      1,
      0,
      0.372370,
      1,
      1,
      0,
      NULL,
      1.776115,
      5.789645,
      0.211237,
      4.906808,
      0,
      0,
      1.378748,
      2.528084,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.224401,
      NULL,
      1,
      3,
      1.782866,
      1.557542,
      NULL,
      1.594028,
      2,
      1.743463,
      1.216843,
      1.362087,
      NULL,
      0,
      0,
      NULL,
      0.247628,
      2,
      2.809721,
      0.286785,
      NULL,
      0.833938,
      3.868796,
      0,
      2,
      1.839046,
      NULL,
      NULL,
      NULL,
      1.259231,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.353050,
      1,
      1,
      0,
      1.049622,
      0,
      0.276653,
      0,
      0,
      0.033697,
      NULL,
      1.078125,
      0,
      NULL,
      0.234978,
      NULL,
      1,
      0.344441,
      NULL,
      0.985748,
      0,
      1.423262,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.329090,
      0.324039,
      1,
      8.019435,
      1.876224,
      8,
      6,
      8,
      7,
      3.695069,
      6.146138,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.623648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.065623,
      0.743390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.089454,
      NULL,
      NULL,
      2,
      NULL,
      1.278111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.787169,
      0.195236,
      NULL,
      NULL,
      NULL,
      0.425983,
      0,
      1,
      1.261260,
      2,
      1,
      0,
      1.985702,
      NULL,
      NULL,
      0.101954,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.611644,
      0.346624,
      0,
      NULL,
      3.638030,
      2,
      1.629869,
      2.096755,
      0,
      1.054710,
      0,
      1.535132,
      0,
      1,
      1.060903,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '20431',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      2.689583,
      1,
      0.205569,
      1,
      1,
      1,
      NULL,
      2,
      NULL);
commit;
end;
/


