set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '3411023',
      NULL,
      0,
      3.098848,
      1,
      '222433',
      3,
      ' 4-18-1987',
      26.815632,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.971594,
      0,
      1.989577,
      1.828035,
      2.836405,
      NULL,
      0,
      0,
      0,
      1.542319,
      NULL,
      0.216952,
      0.457921,
      2.984777,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0.824759,
      NULL,
      NULL,
      0.724932,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.705950,
      0.240347,
      1.681643,
      NULL,
      0.126872,
      1,
      0,
      0.956112,
      0,
      0.071384,
      NULL,
      1.812346,
      1.495333,
      0.269304,
      1,
      1.437747,
      NULL,
      1.576561,
      5,
      1,
      2,
      2.060811,
      NULL,
      NULL,
      NULL,
      1.588743,
      NULL,
      NULL,
      0.796988,
      1,
      4,
      0,
      NULL,
      0.850513,
      1,
      1,
      1,
      0.622768,
      0,
      0,
      1.961451,
      0.009280,
      1,
      1.820704,
      1.416859,
      1.524203,
      0.968698,
      NULL,
      NULL,
      4.231979,
      0,
      NULL,
      3.991474,
      1,
      4.039518,
      NULL,
      1,
      0.019686,
      4.951985,
      NULL,
      2.980182,
      4.971597,
      1.733781,
      NULL,
      0.260337,
      3.865319,
      2.357502,
      7.055296,
      6,
      4.577748,
      4,
      6,
      8.738569,
      6,
      1.899564,
      1,
      0.593238,
      1.718008,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.559422,
      NULL,
      NULL,
      1.015427,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.575810,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      1,
      0.747191,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923970,
      0,
      1,
      1.738853,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.851387,
      0.024118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005534,
      3.716490,
      0.589954,
      0,
      NULL,
      2,
      1.521461,
      0.642915,
      1,
      0,
      0,
      1.097970,
      0,
      1.160320,
      NULL,
      NULL,
      0,
      0.569667,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.485713,
      '13204',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


