set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      48.289747,
      0,
      1,
      2,
      '333011',
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6.129332,
      NULL,
      0,
      1,
      NULL,
      0.956354,
      1,
      1.980954,
      1.798658,
      1,
      1.436840,
      0.688974,
      1.723752,
      NULL,
      1,
      1.716487,
      3,
      NULL,
      1,
      4,
      0.199717,
      0.409195,
      3.906541,
      1,
      5,
      3.387774,
      1.506439,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0.663213,
      1,
      0,
      0.974401,
      1,
      1.490624,
      0.524040,
      1.746956,
      1.037734,
      1.920131,
      1,
      NULL,
      1,
      0,
      0.435433,
      1.616457,
      1.389409,
      1.437584,
      1.749060,
      NULL,
      0,
      7,
      0,
      2,
      3,
      0.255453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.500788,
      NULL,
      1,
      NULL,
      0.856300,
      1,
      NULL,
      NULL,
      1,
      1.541233,
      1,
      1.444992,
      NULL,
      0.743881,
      1.632988,
      0.922001,
      1.369160,
      NULL,
      NULL,
      NULL,
      3.180834,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.328902,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      5.281454,
      1.837891,
      0.763423,
      NULL,
      3.056864,
      5.815808,
      4.436126,
      0,
      3,
      1.151670,
      1,
      6.542897,
      6.715760,
      5.804818,
      NULL,
      1.562184,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.401602,
      0,
      1,
      0,
      1,
      0.741643,
      1,
      1.893913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.607796,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.178519,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289987,
      0,
      0.154422,
      0.672866,
      1.241233,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.077300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.047893,
      0.268916,
      1,
      NULL,
      NULL,
      NULL,
      0.970457,
      0.991628,
      0,
      1,
      NULL,
      1.514210,
      0,
      0.981212,
      0.856864,
      1.698035,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '21230',
      '',
      '',
      1,
      '',
      '',
      '',
      0.309843,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


