set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '4212022',
      32.664005,
      4,
      0,
      1,
      '341143',
      NULL,
      ' 6-23-2002',
      46.696152,
      NULL,
      1,
      NULL,
      6,
      1,
      0.233771,
      1.945232,
      1.456305,
      1,
      1.775744,
      0.984045,
      1.496462,
      1.593614,
      1.012348,
      1.881269,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.794045,
      NULL,
      2,
      1.381028,
      1,
      NULL,
      0,
      4.045898,
      1,
      2.273402,
      1.779890,
      NULL,
      NULL,
      0.941256,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.447541,
      NULL,
      0.208586,
      1.779745,
      0,
      1.251285,
      0.053610,
      0.076097,
      1.773428,
      1,
      1,
      1.517599,
      1,
      0.089731,
      NULL,
      0.251331,
      NULL,
      1.348794,
      1.555771,
      NULL,
      1,
      NULL,
      3.835558,
      0.917051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666332,
      0,
      4,
      0.242889,
      NULL,
      NULL,
      0.784361,
      1,
      NULL,
      0,
      0.899611,
      0,
      1,
      0,
      NULL,
      NULL,
      0.978854,
      1,
      1.648300,
      NULL,
      1,
      3,
      0.020267,
      3.141443,
      1,
      NULL,
      7,
      0.865560,
      3,
      1.334652,
      NULL,
      1.823593,
      NULL,
      0.300625,
      1,
      0,
      0,
      1,
      10,
      8.150568,
      NULL,
      3,
      2.095950,
      4,
      1.415018,
      4.782333,
      7,
      NULL,
      2,
      0,
      NULL,
      2,
      0.117007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.102792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.454285,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239971,
      0,
      0.679094,
      0,
      NULL,
      0.826797,
      NULL,
      NULL,
      NULL,
      1.584732,
      4,
      1.931640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.833043,
      0.263417,
      NULL,
      0.980715,
      0,
      1,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      0.141754,
      NULL,
      1.131748,
      0.882767,
      1.838699,
      1.724557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '41223',
      '',
      '',
      1.698273,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


