set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '1323220',
      NULL,
      2,
      NULL,
      3,
      '433344',
      3,
      '11-24-1983',
      NULL,
      NULL,
      1.084198,
      NULL,
      NULL,
      NULL,
      0,
      1.670592,
      1.230707,
      0.424116,
      1.229217,
      0,
      0,
      1,
      2,
      0,
      NULL,
      1,
      0.493340,
      0.864273,
      9,
      0,
      1,
      NULL,
      2,
      NULL,
      3,
      0,
      0,
      0,
      1.083958,
      0.486182,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      1.690439,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.165479,
      0.989952,
      3,
      NULL,
      NULL,
      NULL,
      0.789191,
      2,
      1,
      2,
      0,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0.221724,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.574814,
      2.435626,
      NULL,
      NULL,
      3,
      0,
      6,
      1,
      1,
      1.518200,
      1,
      0.935318,
      1,
      NULL,
      1.980273,
      1,
      0,
      0,
      0,
      NULL,
      0,
      4,
      3,
      0.737220,
      5,
      0.571062,
      NULL,
      1.529779,
      1,
      0.804549,
      2,
      2.944174,
      5,
      3.465400,
      2,
      NULL,
      1,
      0.369038,
      1,
      NULL,
      NULL,
      7,
      1,
      7.405932,
      5.079247,
      NULL,
      NULL,
      3.877478,
      2.970246,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.578335,
      NULL,
      NULL,
      0,
      1.785238,
      NULL,
      1,
      1.529014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.037716,
      2.008554,
      0.036588,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.766115,
      3.685997,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.707525,
      2.599426,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124051,
      0.153874,
      2.910970,
      1.849077,
      0,
      1,
      0.456719,
      1,
      1.068304,
      2.306507,
      0,
      1,
      NULL,
      1,
      0.881184,
      0,
      0,
      1.330374,
      0.027279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.974057,
      '20044',
      NULL,
      NULL,
      0.925024,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


