set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '0331413',
      14,
      4,
      3.917393,
      0,
      '341030',
      1.670470,
      ' 1-21-1974',
      8,
      NULL,
      1,
      NULL,
      0,
      1.908778,
      3.919159,
      NULL,
      1.777770,
      NULL,
      NULL,
      0,
      2.301202,
      0.571752,
      4.427531,
      0,
      0,
      1,
      0.728222,
      0,
      7,
      NULL,
      0.830936,
      3.039847,
      NULL,
      0.258285,
      8.644621,
      1,
      5,
      0.458150,
      NULL,
      NULL,
      NULL,
      NULL,
      0.473854,
      NULL,
      NULL,
      1.865359,
      0.624078,
      0,
      2.050032,
      1,
      1,
      0,
      1.219524,
      0.790579,
      2.274204,
      2,
      0.099060,
      0,
      0.752143,
      1,
      0,
      1.417162,
      1.417707,
      1.234122,
      NULL,
      0.960854,
      0.711948,
      5,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.717223,
      3,
      5,
      0.138580,
      0,
      0.770688,
      0,
      1,
      0.889073,
      0.648996,
      1.354462,
      0.988704,
      1,
      0,
      1.712490,
      0,
      0.395500,
      NULL,
      1,
      1,
      2.297686,
      2,
      5.047298,
      0.289916,
      0,
      0.593403,
      3.086917,
      3,
      2,
      1.543567,
      5,
      NULL,
      1.510134,
      1.593181,
      5,
      NULL,
      8,
      5.094250,
      0,
      3.729953,
      0.236351,
      NULL,
      8.021594,
      2.187931,
      2.047978,
      0,
      2.157144,
      1.907983,
      0.702043,
      6.958626,
      0.920272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.638556,
      0,
      1,
      0,
      0,
      0.471560,
      0.721651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.458459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.160372,
      1.538193,
      1.599193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618704,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.795332,
      3.062622,
      0.336620,
      NULL,
      3,
      0,
      NULL,
      1,
      2.852640,
      0,
      0,
      NULL,
      0,
      1.907483,
      1.968418,
      1,
      0,
      0.153385,
      0.767299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.906657,
      '04400',
      NULL,
      '',
      0.774286,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


