set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      '0434143',
      11,
      4,
      3.756870,
      3,
      NULL,
      2.772716,
      ' 9-23-1984',
      24.125543,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      1.110600,
      3,
      1,
      0.883366,
      NULL,
      0.813555,
      2,
      1.145068,
      NULL,
      1,
      1.260546,
      0,
      2,
      0.384808,
      NULL,
      1,
      3.201686,
      0.692049,
      5,
      0,
      1.714924,
      0.106110,
      1.881478,
      1.740510,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.265367,
      NULL,
      1,
      1.102466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      5.807226,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.044396,
      NULL,
      NULL,
      1.834277,
      1.571038,
      0.469563,
      0.808154,
      1,
      0,
      1,
      0.443685,
      1.027441,
      0,
      0,
      0,
      0,
      0.355417,
      0.221082,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.031000,
      NULL,
      0.498848,
      1,
      0.715787,
      3.119983,
      NULL,
      1.007935,
      NULL,
      1,
      1,
      0.355583,
      0,
      0.382901,
      0.509453,
      0.819629,
      6.635904,
      8,
      1.740670,
      0,
      2.260425,
      0,
      5.339083,
      0,
      3.585539,
      3.485932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279450,
      0.696946,
      1,
      1,
      0,
      1,
      1.687150,
      1.595376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671612,
      NULL,
      NULL,
      NULL,
      NULL,
      4.766957,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      1.913996,
      NULL,
      NULL,
      NULL,
      5.659534,
      1,
      0,
      0.572068,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.229257,
      1.706010,
      0,
      2.721157,
      1,
      NULL,
      1,
      0.307878,
      3.587291,
      NULL,
      0.596309,
      0.443208,
      0,
      0.784848,
      0,
      1.879754,
      NULL,
      0.685803,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '04413',
      NULL,
      '',
      1.118959,
      NULL,
      '',
      '',
      0.840257,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


