set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      NULL,
      14.418562,
      NULL,
      '0412003',
      144.755277,
      6,
      2,
      2,
      '413234',
      NULL,
      NULL,
      NULL,
      25.457034,
      0,
      NULL,
      4.714022,
      1.876247,
      NULL,
      0.212570,
      0,
      1.471770,
      1,
      0.965035,
      0.016880,
      0.244563,
      NULL,
      1.648406,
      3,
      0,
      0.918835,
      0.189355,
      2,
      1,
      1.674115,
      0,
      0,
      1,
      NULL,
      0,
      1.542246,
      0,
      1,
      0,
      NULL,
      NULL,
      0.474775,
      NULL,
      NULL,
      NULL,
      1.970309,
      1.798504,
      1.829595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793779,
      1,
      1,
      0.247488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321183,
      1.880629,
      1.409749,
      0.375835,
      1,
      1.959600,
      0,
      0,
      NULL,
      1,
      0.420378,
      0.434937,
      NULL,
      1,
      0.577882,
      0.932879,
      0.638320,
      0,
      1.589687,
      NULL,
      1,
      0,
      0.483585,
      1.679837,
      0,
      0.703352,
      0.346705,
      0.273539,
      4.977054,
      1,
      NULL,
      NULL,
      2.478742,
      0.055259,
      3.644275,
      1.426140,
      1.724585,
      6.255244,
      9.756571,
      4,
      NULL,
      1,
      6.998196,
      NULL,
      8.083168,
      2,
      NULL,
      1,
      0.623633,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0.705701,
      0,
      0.779041,
      0.674296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826520,
      NULL,
      NULL,
      NULL,
      NULL,
      4.195634,
      1.984927,
      NULL,
      0.452470,
      0,
      NULL,
      9.774575,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769426,
      0.801412,
      0.738431,
      1.898740,
      2,
      2,
      1.249684,
      NULL,
      NULL,
      NULL,
      1.278547,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410997,
      3.686587,
      3,
      3.245632,
      1.169505,
      1.898341,
      2,
      1,
      0,
      0.604228,
      0,
      1,
      1.552044,
      NULL,
      1,
      1.063099,
      NULL,
      NULL,
      0,
      0.395764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '03001',
      '30424',
      NULL,
      1.851871,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


