set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '140',
      NULL,
      45.665592,
      NULL,
      '1221404',
      NULL,
      NULL,
      2,
      1,
      '041031',
      4.790478,
      ' 7-16-1989',
      8.541766,
      86.656317,
      NULL,
      NULL,
      NULL,
      0.164535,
      0,
      0,
      2.981632,
      NULL,
      1.291587,
      1,
      1.914136,
      0.300251,
      4.829948,
      1,
      1.208007,
      NULL,
      1,
      3,
      3.513211,
      0.751865,
      0,
      1.078137,
      1.123085,
      NULL,
      5.051379,
      0,
      3.093809,
      1,
      0.160996,
      0,
      NULL,
      NULL,
      0.595757,
      NULL,
      NULL,
      1.367453,
      1.205623,
      NULL,
      0.932719,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.601367,
      0.789779,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616758,
      0.300402,
      0.820119,
      0,
      NULL,
      1.484048,
      NULL,
      0,
      1,
      1.646250,
      NULL,
      1,
      0,
      1.894324,
      0,
      0.405448,
      1,
      0,
      1.526809,
      NULL,
      0.622582,
      2,
      NULL,
      1,
      1.218008,
      0.161039,
      4,
      NULL,
      1.759591,
      0.386453,
      1,
      0,
      1.000062,
      1.978851,
      NULL,
      1.174057,
      0,
      5,
      2,
      6,
      0,
      0,
      1.561982,
      NULL,
      NULL,
      1.110075,
      NULL,
      1,
      1,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0.535640,
      0.536416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.893703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.824889,
      NULL,
      1.853264,
      1.707805,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315753,
      3.516337,
      3.115238,
      NULL,
      2.435848,
      0.723120,
      1.239127,
      1,
      0.273772,
      0,
      0,
      1.279782,
      0,
      NULL,
      NULL,
      1.316131,
      1.034776,
      NULL,
      NULL,
      1.439830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.218072,
      '40231',
      '',
      '',
      0.418841,
      '',
      '',
      '',
      0.366625,
      '',
      NULL,
      NULL,
      2.729215,
      0,
      NULL,
      1,
      0.132063,
      0.303081,
      1,
      NULL,
      0.119046);
commit;
end;
/


