set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '24422341',
      61,
      22.798807,
      NULL,
      269.897752,
      5,
      0,
      0,
      NULL,
      0,
      '10- 5-1987',
      14,
      14,
      0.911128,
      NULL,
      1.221781,
      1.655532,
      3,
      0,
      1.019991,
      1,
      NULL,
      0,
      2,
      NULL,
      1.007564,
      1.600180,
      1,
      1.610504,
      0,
      NULL,
      6.884596,
      NULL,
      1,
      0.049164,
      7.993693,
      5,
      2,
      NULL,
      1.655092,
      2,
      NULL,
      0.247943,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.645360,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.955415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672744,
      0.406208,
      0,
      NULL,
      0,
      1.320659,
      1.866034,
      0,
      0.784763,
      NULL,
      1.749577,
      1,
      1.957251,
      1.413590,
      1,
      1.517686,
      1,
      1.632151,
      NULL,
      NULL,
      NULL,
      4.764861,
      1,
      1.567518,
      0.382523,
      1,
      2,
      0.305612,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.095511,
      1.415851,
      1.255835,
      1,
      6.040994,
      2,
      9.544265,
      1,
      5.502417,
      2.300487,
      9,
      1.553957,
      0.920424,
      1.066411,
      1.751245,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784165,
      1,
      NULL,
      0.361286,
      1.213169,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.821149,
      1.909567,
      1,
      NULL,
      NULL,
      NULL,
      1.407253,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.618041,
      1.799684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.588578,
      1,
      2.829398,
      0,
      NULL,
      1.599748,
      1.713594,
      0.881085,
      1,
      0,
      0,
      1,
      0.594881,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.550123,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      '3343',
      NULL,
      '',
      5.679150,
      1.893351,
      3.347124,
      1,
      NULL,
      0,
      NULL,
      1.206896,
      0);
commit;
end;
/


