set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      NULL,
      NULL,
      71,
      '1022332',
      NULL,
      NULL,
      3,
      0,
      '143201',
      5.006542,
      ' 9-11-1987',
      29.053853,
      NULL,
      1.685985,
      NULL,
      1.891295,
      1,
      0.452509,
      1,
      0,
      NULL,
      1.647939,
      1,
      1,
      0,
      0.830348,
      1,
      NULL,
      1,
      1.554138,
      0,
      4.801604,
      0,
      0,
      NULL,
      NULL,
      0.961616,
      1,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.328754,
      1.829769,
      0,
      1.433380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285313,
      NULL,
      1.468121,
      0.560086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794565,
      NULL,
      NULL,
      NULL,
      0.889128,
      0,
      NULL,
      1.160441,
      1.149519,
      1.368936,
      0.687425,
      1,
      1,
      1.121878,
      0.831750,
      0.126744,
      1,
      1.532973,
      1.017731,
      NULL,
      NULL,
      5,
      1.025922,
      NULL,
      0.741028,
      NULL,
      1.793195,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097967,
      0.821019,
      1.658375,
      0.530693,
      1.443552,
      9.227128,
      NULL,
      7.708064,
      1,
      2.146548,
      7,
      1.947708,
      5.472828,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.788854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345640,
      0.400065,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034906,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038093,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.585963,
      0,
      0.139657,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697138,
      1,
      NULL,
      0.605132,
      0.629568,
      0.331448,
      0,
      1,
      1.424764,
      1.463381,
      1.368906,
      1.056722,
      0.570302,
      1,
      NULL,
      0.050342,
      0.989884,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.851527,
      NULL,
      '',
      '',
      1.269964,
      '',
      '',
      '',
      2.441986,
      '1433',
      NULL,
      '',
      0.596130,
      NULL,
      2.488774,
      3,
      3,
      0.888549,
      3.808868,
      0,
      0.821449);
commit;
end;
/


