set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '114',
      '14010041',
      28.458217,
      NULL,
      NULL,
      23,
      0,
      NULL,
      NULL,
      '204412',
      NULL,
      ' 1-21-1996',
      6.311427,
      40,
      0.101440,
      NULL,
      1,
      1.489238,
      2.301559,
      0.336598,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1.826320,
      0,
      1.382812,
      0,
      1.961110,
      3.992577,
      1.594451,
      1.290573,
      5,
      3.994931,
      NULL,
      1,
      2,
      1,
      2.322141,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.815513,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.801094,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.233894,
      1,
      NULL,
      1.642982,
      1,
      1.874077,
      1.548297,
      0,
      0.236888,
      NULL,
      NULL,
      0.498172,
      0.842169,
      1,
      0.344817,
      1,
      0,
      0,
      0,
      NULL,
      1.470211,
      4.295348,
      NULL,
      0,
      NULL,
      1.899979,
      1,
      NULL,
      NULL,
      1,
      0,
      0.543905,
      0,
      0,
      1,
      1,
      NULL,
      3,
      7.073831,
      NULL,
      3,
      6,
      5,
      3,
      4,
      1,
      1,
      0.062780,
      1,
      NULL,
      NULL,
      9.795876,
      1.722884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088740,
      NULL,
      0,
      1,
      NULL,
      1,
      1.752017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.368527,
      0,
      NULL,
      2,
      NULL,
      1,
      9.546274,
      2,
      0.088198,
      NULL,
      NULL,
      NULL,
      1,
      1.174495,
      1,
      NULL,
      1,
      1,
      0.888318,
      NULL,
      NULL,
      NULL,
      0.263294,
      3.734767,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.709117,
      NULL,
      0,
      NULL,
      2.274543,
      1.552118,
      NULL,
      1.303968,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.898917,
      NULL,
      0,
      0.073668,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '23431',
      '',
      '',
      0.121169,
      '',
      '',
      '',
      4,
      '0422',
      '3443',
      '',
      1.313647,
      1.205028,
      2,
      3.094018,
      2,
      NULL,
      3,
      0,
      NULL);
commit;
end;
/


