set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2234',
      '31030444',
      10.044136,
      NULL,
      '4041301',
      6.384654,
      6,
      1.036421,
      NULL,
      '211433',
      NULL,
      ' 8-24-1998',
      7.326537,
      39,
      0.611653,
      NULL,
      NULL,
      3.570359,
      0.088940,
      1.448121,
      1,
      1,
      0.408545,
      0.589376,
      1,
      0.097080,
      4,
      1.035807,
      0,
      0,
      1.980288,
      0.977063,
      3.434660,
      1,
      NULL,
      1,
      NULL,
      0.404065,
      2,
      0,
      3.356669,
      2,
      NULL,
      1.065893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565655,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.709663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527522,
      1.170586,
      1,
      1,
      0.698048,
      0,
      1.036441,
      NULL,
      1,
      0,
      0.787923,
      1,
      1.043926,
      1.138073,
      1.096144,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.113046,
      1,
      NULL,
      1.855922,
      0,
      0,
      1,
      NULL,
      0.747340,
      0,
      0.643751,
      NULL,
      1.440122,
      NULL,
      4,
      2.907058,
      0,
      3,
      3.401851,
      NULL,
      7,
      1,
      NULL,
      0.736328,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123931,
      1,
      1,
      NULL,
      0,
      NULL,
      1.616378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.831379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.286076,
      1.335073,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.566819,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427363,
      0.698906,
      0.665939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.505754,
      2.093793,
      1,
      2.689220,
      NULL,
      0.009578,
      1.114313,
      0,
      NULL,
      0.618345,
      NULL,
      1.514513,
      NULL,
      0.977978,
      0,
      NULL,
      1,
      NULL,
      0.417619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.574566,
      '31322',
      '',
      '',
      0.774303,
      '',
      '',
      NULL,
      4,
      '2121',
      '3212',
      '33334',
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      2.265455,
      0.835889,
      2);
commit;
end;
/


