set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3002',
      '32344303',
      NULL,
      54.425593,
      '2424231',
      69.685955,
      2,
      2.341894,
      0,
      NULL,
      3,
      ' 0-29-1998',
      12.055292,
      60.811414,
      0,
      NULL,
      5,
      2,
      NULL,
      0.321415,
      3,
      1,
      0.636532,
      1,
      NULL,
      1.730111,
      2.269460,
      NULL,
      0.382138,
      1,
      0.235582,
      3.079850,
      NULL,
      0,
      1,
      0.237209,
      0.098935,
      0.540024,
      2,
      NULL,
      0,
      0,
      1.491998,
      0,
      NULL,
      NULL,
      1.314835,
      NULL,
      NULL,
      0,
      NULL,
      1.674116,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.071224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432420,
      NULL,
      NULL,
      1,
      0,
      1.946334,
      1,
      1.826405,
      0,
      1.080306,
      1.641187,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1.195153,
      1.417144,
      NULL,
      0.885268,
      0,
      0,
      1,
      0.778882,
      1,
      5.962683,
      NULL,
      3.384168,
      NULL,
      5,
      NULL,
      0,
      5.804464,
      1,
      0,
      0.749609,
      0,
      NULL,
      NULL,
      9.665975,
      0.459630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.684158,
      0,
      0,
      0,
      0.274259,
      0.961226,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.189795,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.829205,
      0,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.209728,
      0.097456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926495,
      NULL,
      2.428392,
      0,
      NULL,
      0.556618,
      1.979301,
      0,
      1.657334,
      2,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448045,
      '43320',
      '',
      '',
      1.643351,
      '',
      '',
      NULL,
      0.581202,
      NULL,
      '1243',
      NULL,
      NULL,
      NULL,
      0.951376,
      NULL,
      3,
      2,
      1.114100,
      1.876944,
      3.603391);
commit;
end;
/


