set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1001',
      '31300300',
      51.490456,
      20,
      '2442201',
      26,
      4,
      2.279856,
      0,
      '311014',
      1,
      NULL,
      8,
      7,
      NULL,
      NULL,
      1,
      2,
      1.310882,
      NULL,
      2.620761,
      0,
      NULL,
      NULL,
      3.775475,
      1.832383,
      1,
      NULL,
      0,
      0.343746,
      0.692194,
      NULL,
      3.239692,
      NULL,
      0,
      0,
      0.031571,
      NULL,
      0,
      NULL,
      2,
      1.588644,
      3.906770,
      0,
      NULL,
      NULL,
      1.184748,
      NULL,
      NULL,
      1,
      0.236787,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.931122,
      0.958128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642734,
      1.790824,
      0.384729,
      NULL,
      NULL,
      1.404265,
      NULL,
      1,
      0.330694,
      1.143652,
      1.428765,
      NULL,
      0.205273,
      NULL,
      1.123411,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.453875,
      NULL,
      1,
      0.739722,
      0.802283,
      5,
      0.527068,
      1.801349,
      1,
      NULL,
      1,
      0.611571,
      NULL,
      0.752160,
      1,
      1,
      NULL,
      3.576648,
      7,
      2,
      NULL,
      0.589254,
      5.436986,
      6,
      1,
      1.133365,
      1.594473,
      0.987846,
      NULL,
      NULL,
      0.243560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507549,
      1,
      NULL,
      0,
      1,
      0.894588,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.940541,
      NULL,
      NULL,
      NULL,
      1,
      1.660655,
      0.089504,
      3,
      1.623851,
      NULL,
      0.358827,
      NULL,
      NULL,
      NULL,
      NULL,
      2.845671,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0.576634,
      3,
      1,
      1.914270,
      0.869329,
      NULL,
      NULL,
      1.210785,
      0,
      1.271696,
      0.731649,
      1,
      0,
      1,
      1.797791,
      1,
      0.903949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '32044',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      3.372167,
      '32442',
      NULL,
      '4202',
      2,
      NULL,
      0.937843,
      0,
      0.899477,
      0.459251,
      1.518082,
      0.736340,
      3.565251);
commit;
end;
/


