set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8611144';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0412',
      '0',
      82.145019,
      84.154591,
      '3144212',
      86.251941,
      2,
      0.954024,
      3,
      '144333',
      1.964350,
      ' 7-11-1984',
      0.059073,
      6,
      1.467429,
      NULL,
      6,
      NULL,
      3,
      NULL,
      1,
      0,
      1.878448,
      1.500216,
      2,
      1.874731,
      0,
      1,
      1,
      0.512790,
      NULL,
      NULL,
      1,
      0.266570,
      1,
      0,
      0.457210,
      1.495534,
      4,
      0,
      NULL,
      NULL,
      1.458212,
      0.846275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.276693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.449422,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791006,
      0.036708,
      NULL,
      1,
      0.632423,
      NULL,
      1,
      1.612891,
      NULL,
      1,
      1,
      1.485616,
      0.442005,
      1,
      1.121446,
      NULL,
      1,
      NULL,
      NULL,
      1.615522,
      4.536285,
      0,
      1,
      2.774787,
      1,
      2.234251,
      0,
      0,
      0.299113,
      NULL,
      0,
      1,
      0.464703,
      1.369162,
      1,
      NULL,
      6,
      NULL,
      NULL,
      2.379938,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778445,
      1.698332,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.433074,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005319,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.939952,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.023557,
      1.533135,
      1,
      1.518825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782126,
      1.628501,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.158371,
      1,
      0.868890,
      0,
      1,
      NULL,
      1,
      1.746695,
      0,
      1.087391,
      1.523413,
      0.522185,
      0.614616,
      0.573961,
      0.396928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '43144',
      '',
      '',
      0.949355,
      '',
      '',
      '',
      NULL,
      '2201',
      '4034',
      '12324',
      1.198799,
      3.187136,
      2.263742,
      NULL,
      NULL,
      3,
      1,
      0.317617,
      1.536036);
commit;
end;
/


