set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      NULL,
      45.030840,
      NULL,
      NULL,
      8.168306,
      NULL,
      2,
      NULL,
      NULL,
      2.149293,
      ' 1-19-2000',
      54,
      36.039638,
      0.207060,
      NULL,
      0.090217,
      3,
      NULL,
      0,
      0,
      1.398938,
      1,
      1,
      2,
      0.376527,
      3.130428,
      1,
      NULL,
      NULL,
      1,
      0,
      6.296565,
      0,
      0.180673,
      1.758147,
      1.152114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.523254,
      4.086702,
      0.183454,
      4.562870,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.313158,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.503045,
      NULL,
      0,
      0.479623,
      0,
      1.198030,
      NULL,
      1,
      0.960007,
      0.275124,
      0.737184,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714771,
      0.739446,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      5.612400,
      NULL,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      0.902704,
      7,
      2,
      NULL,
      0,
      5,
      0,
      0.331758,
      3,
      2,
      5,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      0.306850,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      5.193898,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.281762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.590644,
      2.350530,
      0,
      NULL,
      2,
      0.773068,
      0.192021,
      1.189139,
      NULL,
      NULL,
      NULL,
      1.857324,
      1,
      0.005606,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.541344,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161490,
      3.571681,
      0.549457,
      0.789984,
      NULL,
      0.323416,
      NULL,
      2.772967,
      0,
      3.925905,
      2,
      1,
      1,
      0.586288,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.707311,
      0,
      0.256039,
      1,
      0,
      0.798881,
      1,
      2,
      1.647024,
      1,
      1.225552,
      1,
      1,
      NULL,
      0.177578,
      0,
      0,
      0,
      NULL,
      0.115983,
      0,
      1,
      1.502007,
      0.995575,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908469,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      2.892933,
      NULL,
      2.967615,
      2,
      4,
      '10044',
      '34141',
      '',
      1.172413,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      0.143095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


