set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '34',
      37,
      41.644334,
      '0243424',
      28,
      4,
      3.069885,
      1,
      '014411',
      5.879098,
      ' 1-29-1998',
      NULL,
      15.851241,
      1.680141,
      NULL,
      1.444730,
      NULL,
      1.365785,
      0,
      1,
      0.065797,
      3,
      2.822855,
      1,
      NULL,
      3,
      0,
      0.862042,
      1.321113,
      NULL,
      0.899968,
      5.503618,
      0.182533,
      1,
      0.726950,
      0,
      1,
      3,
      NULL,
      1.607971,
      NULL,
      0.532049,
      0.186874,
      NULL,
      NULL,
      0.878998,
      NULL,
      NULL,
      1.834073,
      NULL,
      1,
      1.728378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.263041,
      1.416556,
      0.113333,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.598645,
      0.944531,
      0,
      NULL,
      NULL,
      1.910156,
      NULL,
      1.067479,
      0,
      1.170594,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.087856,
      0.191826,
      0,
      NULL,
      NULL,
      0,
      0.245238,
      4,
      0,
      1.626615,
      0.290397,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.069525,
      0,
      3,
      NULL,
      4.429501,
      6.789049,
      NULL,
      0.302437,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067136,
      1.924349,
      0,
      0,
      0,
      NULL,
      2.961826,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.747982,
      NULL,
      9,
      3,
      0.107502,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.032718,
      1.246780,
      NULL,
      NULL,
      NULL,
      4.086144,
      1,
      1.382967,
      NULL,
      6,
      NULL,
      0.972734,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.170772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815948,
      2,
      NULL,
      0.084911,
      0,
      0.797408,
      2.348275,
      2,
      0,
      1.070100,
      1.520665,
      0.969801,
      NULL,
      NULL,
      NULL,
      NULL,
      0.926406,
      0.607146,
      1.470093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '24010',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.512906,
      '',
      '',
      NULL,
      0,
      3.882024,
      0,
      5,
      1,
      NULL,
      NULL,
      5,
      4);
commit;
end;
/


