set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      '24414221',
      50.713454,
      7.965688,
      '1413444',
      NULL,
      4,
      0.723309,
      NULL,
      '334032',
      5.048458,
      ' 4-23-1988',
      20,
      NULL,
      0,
      NULL,
      1,
      0.147121,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      1,
      1,
      0.020972,
      0,
      1,
      0.124286,
      0.966267,
      0.060665,
      0,
      1.353902,
      0,
      1,
      NULL,
      1.856406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.181140,
      1,
      1.831270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.614788,
      1.540408,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.184961,
      3,
      1.513956,
      NULL,
      1.202780,
      1.541793,
      1.998887,
      1.866156,
      NULL,
      1,
      1,
      1.718218,
      1.664134,
      NULL,
      1,
      0,
      NULL,
      1.461219,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1.805316,
      1,
      3,
      1.709837,
      0,
      NULL,
      NULL,
      0,
      3,
      0.056891,
      1,
      2.738313,
      0,
      NULL,
      0.775197,
      0.270663,
      0.037692,
      NULL,
      NULL,
      1,
      1.526872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.219143,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.238198,
      NULL,
      1,
      0.661528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.019119,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.178188,
      1.315105,
      1.825718,
      3.955182,
      NULL,
      1,
      1.819327,
      NULL,
      NULL,
      NULL,
      0,
      0.966648,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995919,
      2.011068,
      0.603524,
      0,
      0,
      NULL,
      NULL,
      2,
      0.649459,
      1,
      NULL,
      0,
      0.763273,
      0.053364,
      0.679468,
      0.076239,
      0.796607,
      1.809676,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176700,
      1.254810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832911,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365796,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242905,
      1,
      0,
      NULL,
      0.975292,
      NULL,
      1,
      0,
      4.964443,
      '34113',
      '12033',
      NULL,
      0.845613,
      '',
      '',
      NULL,
      1,
      '0233',
      '',
      '',
      4,
      1.753509,
      3,
      2.839294,
      3,
      3,
      0.337818,
      3.578354,
      1);
commit;
end;
/


