set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603902';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1141',
      NULL,
      63,
      17.361922,
      '4440033',
      127,
      5,
      NULL,
      1,
      NULL,
      1.432953,
      NULL,
      NULL,
      16,
      1.520527,
      NULL,
      NULL,
      1.062467,
      NULL,
      1,
      3,
      0,
      1,
      0,
      NULL,
      1.308029,
      0.550306,
      0,
      1,
      0.748458,
      NULL,
      1.518288,
      0.028155,
      1.560704,
      1,
      1,
      NULL,
      1.113238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.173183,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.888898,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106757,
      3.754953,
      1,
      2.463361,
      0,
      NULL,
      0,
      0,
      1.242630,
      0.623845,
      0.359515,
      0.027157,
      0.976371,
      0,
      1.317358,
      0.375125,
      1.898614,
      0.260849,
      NULL,
      1,
      0,
      NULL,
      1,
      1.454676,
      1.972737,
      1,
      1,
      0.242158,
      5.329934,
      1.945548,
      0.171499,
      0,
      NULL,
      0.712874,
      NULL,
      4.335989,
      0.488906,
      2.367519,
      NULL,
      4.048254,
      1,
      2,
      NULL,
      0.450356,
      1.468281,
      NULL,
      0.214683,
      0.191687,
      NULL,
      NULL,
      8.689259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669920,
      NULL,
      0,
      0,
      0,
      1,
      5,
      0.727791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.006985,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.227119,
      1.974037,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.247934,
      0,
      0,
      1,
      0.477922,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.622972,
      0,
      1.182542,
      0.050303,
      2.684363,
      1.386534,
      0.995363,
      3,
      1.309439,
      1,
      NULL,
      1.905996,
      0.583700,
      0.437855,
      1.159441,
      0.264476,
      NULL,
      1,
      1,
      0.917817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '24214',
      '44012',
      NULL,
      0,
      '',
      '',
      '',
      1.695444,
      '',
      '',
      '',
      NULL,
      4.130489,
      2,
      2.120017,
      1,
      NULL,
      3,
      1.339058,
      NULL);
commit;
end;
/


