set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102851';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      11,
      2,
      NULL,
      3,
      '114230',
      NULL,
      ' 1- 3-1980',
      19,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.275236,
      NULL,
      3,
      1,
      1,
      1.368031,
      0.309870,
      1.198059,
      0.144835,
      NULL,
      0.052015,
      NULL,
      0.103518,
      3.217111,
      NULL,
      1,
      NULL,
      0,
      0,
      1.350367,
      NULL,
      0,
      5,
      0.767184,
      1.775041,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384052,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928549,
      1,
      NULL,
      1.700219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.641140,
      1.370323,
      0,
      3.058798,
      NULL,
      1,
      0,
      0,
      0.928652,
      0.203825,
      1.814222,
      NULL,
      0,
      0.168942,
      NULL,
      0.737196,
      1.571048,
      1.217975,
      NULL,
      0.943032,
      1.347825,
      NULL,
      1.368506,
      0,
      0.683127,
      0.411279,
      0,
      0,
      3.596537,
      5.636041,
      8,
      2,
      1.641864,
      7.975289,
      0,
      1.719041,
      5.456949,
      0,
      NULL,
      1.400440,
      NULL,
      2,
      11.050005,
      NULL,
      NULL,
      7,
      0,
      1,
      0,
      NULL,
      0.929966,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237501,
      NULL,
      1,
      0,
      0,
      0.063945,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222403,
      NULL,
      3,
      2.449409,
      0.275123,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.365602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      3.284923,
      NULL,
      2,
      NULL,
      0.013392,
      NULL,
      NULL,
      NULL,
      1,
      2.953444,
      1.677650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717385,
      1.609618,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.326480,
      0,
      1.811249,
      NULL,
      0.662182,
      1.684860,
      0,
      1.320861,
      0,
      0.918991,
      1.265461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107079,
      '',
      '',
      '',
      2,
      '21243',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


