set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102851';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '10214403',
      16.385901,
      41.219748,
      NULL,
      19,
      0,
      2.485368,
      1,
      '341244',
      0.873867,
      ' 4-11-1993',
      5,
      29.547282,
      1.395879,
      NULL,
      1.772980,
      1,
      2.174275,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.763402,
      NULL,
      1.567238,
      1.584230,
      1.278514,
      NULL,
      0,
      3,
      0.970070,
      1.913231,
      NULL,
      0.367405,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950527,
      1,
      0,
      1.620728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504514,
      1.650528,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501852,
      2.609536,
      3.792499,
      7,
      0.142021,
      1.732726,
      1.592100,
      1.002665,
      0.253073,
      1,
      NULL,
      NULL,
      1.062479,
      0,
      0.565609,
      1.689113,
      1.740162,
      1,
      NULL,
      0.063877,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.626650,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.922864,
      0.928352,
      1.902547,
      0,
      1.444952,
      1,
      5.191426,
      0.616077,
      NULL,
      6,
      4.419817,
      0,
      1.614799,
      0.900890,
      2.473910,
      NULL,
      0.724586,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.866598,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.748607,
      0.899022,
      5.996251,
      NULL,
      2,
      0.752816,
      NULL,
      NULL,
      NULL,
      1.261366,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.898013,
      1,
      NULL,
      NULL,
      0.792933,
      1,
      NULL,
      1,
      0.061743,
      0.446932,
      1,
      1,
      0.379709,
      0,
      1.276199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '',
      '',
      '',
      2.989361,
      '00003',
      NULL,
      NULL,
      3.001293,
      '4023',
      NULL,
      NULL,
      4,
      1.287768,
      1.743544,
      2.356097,
      3.714162,
      0.097603,
      NULL,
      NULL,
      6);
commit;
end;
/


