set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102851';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      '40004102',
      76.009092,
      NULL,
      '2010141',
      110.830670,
      2,
      NULL,
      3,
      NULL,
      3.220790,
      ' 2-13-1984',
      2,
      NULL,
      0.045535,
      NULL,
      0.522161,
      0.609324,
      0,
      NULL,
      0.579402,
      3,
      0,
      1,
      1,
      0.537896,
      3,
      1,
      NULL,
      0.467401,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      1.353191,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.927967,
      0.771381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983600,
      1.076705,
      1,
      1.272528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238878,
      4.067057,
      2.251401,
      0.094328,
      NULL,
      1.696369,
      1,
      1,
      0,
      0,
      1,
      1.612439,
      0.816270,
      0.250060,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1.317957,
      1.076934,
      0,
      1.634431,
      0.784624,
      0,
      0.451136,
      0,
      NULL,
      1.466754,
      0.436833,
      2.645395,
      4.245543,
      0,
      4,
      1,
      0,
      0.809152,
      1.024949,
      1,
      NULL,
      7,
      NULL,
      1,
      2.614039,
      2,
      0,
      3.320963,
      NULL,
      1.520268,
      1,
      8.460600,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      1.936808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.973970,
      1,
      3.029703,
      0.204942,
      2.934960,
      0.815019,
      0.509443,
      1.589145,
      0.678504,
      0.498732,
      1.497232,
      1.722009,
      2.329166,
      1.352197,
      1,
      3,
      0.071626,
      NULL,
      NULL,
      1.627290,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      8.602074,
      0.680515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.565406,
      NULL,
      1.744027,
      0,
      0.566008,
      2.358148,
      3.080299,
      NULL,
      2,
      1,
      1.710754,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.536273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.698320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.508751,
      '',
      '',
      '',
      1.031891,
      '30011',
      '',
      '',
      1.818790,
      NULL,
      NULL,
      '',
      4,
      0,
      1.301859,
      2,
      2.550062,
      1.728700,
      3.306166,
      NULL,
      3.842419);
commit;
end;
/


