set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '4331411',
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-25-2002',
      55.417965,
      NULL,
      1.910275,
      NULL,
      1.541176,
      1.089628,
      1,
      NULL,
      0,
      NULL,
      1,
      2,
      1,
      0,
      NULL,
      1.284583,
      4.965698,
      0.707006,
      2.723823,
      0,
      3.385107,
      0,
      NULL,
      0,
      0.744901,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.993951,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.058221,
      1,
      2.609273,
      0,
      1.366031,
      2,
      2,
      0,
      NULL,
      3.554668,
      1.932806,
      0,
      3.386187,
      NULL,
      3,
      NULL,
      1.315363,
      0.920944,
      1,
      NULL,
      2,
      5.448392,
      1,
      1,
      2.360295,
      0.672644,
      NULL,
      NULL,
      1.371896,
      NULL,
      NULL,
      0.464373,
      NULL,
      0.147793,
      NULL,
      1.701240,
      1,
      1.443365,
      1.741006,
      NULL,
      NULL,
      1,
      0.810922,
      0.607744,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0.607075,
      1,
      NULL,
      1,
      1.646027,
      NULL,
      1,
      NULL,
      0.060833,
      2.079119,
      1.599577,
      1,
      1,
      3,
      0.402936,
      NULL,
      1.751719,
      2,
      0,
      5,
      3.430732,
      0.127046,
      4,
      NULL,
      NULL,
      1,
      NULL,
      2.396693,
      NULL,
      0.147285,
      NULL,
      0.962405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.457016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7,
      1,
      0.958781,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527423,
      0.543853,
      5,
      1.589819,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274516,
      NULL,
      0.863817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.899990,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0.540392,
      0,
      1.198326,
      0,
      NULL,
      0,
      NULL,
      1,
      1.752613,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.344808,
      '22311',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      1.209663,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


