set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '3343413',
      50.464024,
      NULL,
      1,
      3,
      NULL,
      2,
      ' 6-26-1976',
      57.122386,
      NULL,
      0,
      NULL,
      0,
      0.304124,
      2,
      1,
      0.371807,
      NULL,
      0.232045,
      1.357570,
      NULL,
      1,
      0.351232,
      0.062495,
      3,
      1.602395,
      6,
      0,
      1.164409,
      1,
      4,
      4.738354,
      2,
      5.150919,
      0,
      1,
      3,
      3,
      2,
      1,
      NULL,
      NULL,
      0.226942,
      NULL,
      NULL,
      3,
      4.807205,
      0,
      3,
      0,
      1.127154,
      2,
      1,
      NULL,
      0,
      0.916288,
      2.999256,
      2,
      0.326462,
      NULL,
      NULL,
      0.996366,
      1.955713,
      2,
      0,
      1,
      0,
      4.202307,
      1,
      2,
      2,
      0.580198,
      NULL,
      NULL,
      0.458510,
      NULL,
      NULL,
      1,
      1,
      0.711297,
      0,
      0.650393,
      1.686273,
      NULL,
      NULL,
      0,
      NULL,
      1.998886,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.398676,
      0.762183,
      NULL,
      0,
      NULL,
      1.553648,
      NULL,
      1.069844,
      1.086258,
      0.721273,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.733000,
      1,
      0.166327,
      1.343625,
      1,
      2.027934,
      4,
      2.167387,
      4.436020,
      NULL,
      3,
      3,
      3,
      5.933617,
      NULL,
      NULL,
      2.061992,
      0.986113,
      1.176879,
      3.467313,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717850,
      1,
      0,
      0,
      0.631737,
      1.686317,
      0.119095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249124,
      0.013399,
      3.496812,
      2.438043,
      1.744028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935051,
      1.746861,
      4.575180,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909804,
      1.733924,
      0.838820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.228657,
      NULL,
      3,
      0.251562,
      1,
      NULL,
      1,
      0,
      0,
      0,
      0.151230,
      1,
      NULL,
      NULL,
      0.913890,
      NULL,
      0,
      1.926820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '01340',
      '',
      NULL,
      1.040209,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


