set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01',
      2,
      NULL,
      '2313244',
      NULL,
      1,
      0,
      NULL,
      '212240',
      2.335344,
      ' 8-18-1994',
      64,
      32.683562,
      1.920721,
      NULL,
      0,
      NULL,
      0.305505,
      1.728300,
      NULL,
      0.905649,
      1,
      0,
      1,
      1,
      3,
      NULL,
      0.241435,
      1,
      3.184639,
      1,
      2.562834,
      1,
      0.104880,
      0,
      4.597920,
      1.778660,
      0.743448,
      0,
      0,
      1.461695,
      NULL,
      0.793249,
      NULL,
      NULL,
      0.545576,
      NULL,
      NULL,
      6.767941,
      1.087002,
      1,
      1,
      0.390815,
      NULL,
      0.213370,
      2.082274,
      2,
      NULL,
      3,
      2.075676,
      NULL,
      NULL,
      1.914558,
      2.915374,
      1,
      NULL,
      0.536342,
      1,
      1.855886,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925630,
      NULL,
      NULL,
      0.037244,
      NULL,
      NULL,
      NULL,
      1,
      0.298257,
      1.815451,
      1.972974,
      0,
      NULL,
      NULL,
      1.395909,
      0,
      NULL,
      NULL,
      1.023014,
      1.102582,
      0,
      0,
      1.780958,
      1,
      0.571507,
      NULL,
      NULL,
      0,
      0.479780,
      0.804849,
      1,
      0,
      0,
      1.168212,
      0.522828,
      NULL,
      1.221806,
      1.238079,
      0,
      0.841367,
      0.333881,
      NULL,
      NULL,
      2.643804,
      1.684875,
      1,
      0.063880,
      1.188322,
      4.727323,
      7.698607,
      2,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      7,
      1.738892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.579854,
      0,
      0,
      NULL,
      1,
      0.997639,
      1.607494,
      0.587317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.766696,
      NULL,
      2.371784,
      NULL,
      1.484112,
      NULL,
      NULL,
      NULL,
      0.650264,
      0.618293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779769,
      NULL,
      1.401146,
      1,
      1.534626,
      1.172827,
      1.701965,
      1.604812,
      1.073828,
      1.239054,
      1,
      1.415533,
      0,
      NULL,
      NULL,
      1,
      1.492685,
      1.271328,
      0.585791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.029355,
      '31221',
      '',
      '',
      0,
      '',
      '',
      '',
      1.780720,
      '',
      '',
      '',
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


