set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7317977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      '04',
      47,
      6,
      '4102434',
      66.533769,
      2,
      NULL,
      NULL,
      '344120',
      5,
      ' 3-23-1983',
      24.961899,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      0.270577,
      0,
      1,
      1.878866,
      NULL,
      1.013429,
      1,
      3.102391,
      1.870090,
      0.025160,
      1.356086,
      5.697268,
      NULL,
      5.979128,
      NULL,
      0,
      1,
      7.936833,
      1.806117,
      7,
      1,
      0.069914,
      NULL,
      1.412800,
      0,
      NULL,
      NULL,
      0.159806,
      NULL,
      NULL,
      0,
      3,
      1,
      0.314024,
      0.990874,
      1,
      NULL,
      NULL,
      NULL,
      0.221684,
      3,
      2.734244,
      NULL,
      3.869633,
      1.565674,
      2,
      0.113749,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.539482,
      1,
      0,
      1.250928,
      1,
      NULL,
      NULL,
      0.389495,
      NULL,
      NULL,
      0,
      1,
      1.666744,
      1,
      NULL,
      NULL,
      1.622832,
      1.287883,
      NULL,
      1.938795,
      0,
      1.996712,
      1.759916,
      1,
      NULL,
      0.320978,
      1,
      0,
      0,
      NULL,
      1.477555,
      0.516640,
      NULL,
      NULL,
      0.327860,
      1.405554,
      0.648128,
      NULL,
      1.054270,
      1.368277,
      0,
      1.704929,
      0,
      0,
      0,
      1.477800,
      4,
      4,
      4.062308,
      1,
      0.068876,
      1.429108,
      NULL,
      1.849662,
      3.834322,
      0.682075,
      3.403074,
      0,
      0,
      0.295403,
      0.460364,
      NULL,
      0.326700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265052,
      1,
      1,
      0,
      1,
      1.784539,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722830,
      1.037913,
      0.958015,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198135,
      1.031577,
      0.434502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.560790,
      NULL,
      3,
      1,
      0.324742,
      0.476710,
      1.924415,
      0.159903,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.475325,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196369,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.685052,
      NULL,
      '',
      NULL,
      0.691148,
      '',
      NULL,
      '',
      0.900269,
      NULL,
      '',
      '',
      1.454797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


