set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      '31133442',
      14.316270,
      70,
      '3000412',
      12.314100,
      1,
      NULL,
      3,
      '442010',
      2,
      ' 3-14-1989',
      25,
      8,
      NULL,
      NULL,
      3.455472,
      NULL,
      0,
      0.171787,
      2.785437,
      0,
      1,
      2.741994,
      1.986605,
      0,
      6.353887,
      1,
      4,
      NULL,
      0,
      1,
      3.051430,
      1.039804,
      5.216874,
      1,
      NULL,
      NULL,
      2,
      0,
      1.920209,
      1,
      2.458799,
      1,
      NULL,
      NULL,
      1.464459,
      NULL,
      NULL,
      6.565091,
      3,
      1,
      1,
      1,
      1,
      1,
      2,
      NULL,
      1.495899,
      0,
      1,
      0,
      NULL,
      0,
      1.873672,
      0,
      2,
      3,
      1.840336,
      0.679065,
      3,
      3.584537,
      1,
      1,
      2.452038,
      1.430961,
      NULL,
      NULL,
      1.790971,
      NULL,
      NULL,
      2,
      3,
      2.014175,
      0,
      0.404772,
      0.291518,
      0,
      1,
      0,
      0,
      0,
      1,
      0.191444,
      0.132214,
      0,
      0,
      0,
      0,
      1.362687,
      NULL,
      1,
      1,
      1.974482,
      2,
      1,
      1,
      3,
      0,
      4.531550,
      1.926685,
      1.033857,
      4,
      0,
      NULL,
      3.411700,
      1.231970,
      5,
      0,
      5.280348,
      0.525534,
      3.153713,
      NULL,
      2,
      0.303695,
      NULL,
      1,
      0.061765,
      1,
      2.130978,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300290,
      1.038033,
      NULL,
      1,
      NULL,
      0.161771,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.704050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.702865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.499047,
      4,
      4,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      2.673754,
      3,
      1.271973,
      NULL,
      0.053481,
      2.105956,
      3.507688,
      0.513959,
      0,
      0.010701,
      0,
      NULL,
      1,
      1,
      NULL,
      1.239934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.446345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809759,
      NULL,
      NULL,
      NULL,
      0.308485,
      1,
      NULL,
      0.447318,
      '31204',
      '',
      '',
      1.813265,
      '',
      '',
      NULL,
      0.864065,
      '',
      NULL,
      '',
      2.376140,
      5,
      2.061169,
      2,
      NULL,
      3.693028,
      1,
      3,
      1.022226);
commit;
end;
/


