set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '200',
      NULL,
      66,
      26.132781,
      '4213132',
      24,
      3,
      2,
      NULL,
      '110043',
      0.831473,
      ' 3-29-1998',
      24,
      39.947391,
      0.496479,
      NULL,
      0,
      NULL,
      1.115630,
      1.243785,
      1,
      0,
      1.817334,
      NULL,
      1,
      1.696903,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.720990,
      1,
      3,
      0,
      1.854191,
      0.940595,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.881934,
      0,
      1.700586,
      0.277972,
      1,
      0,
      1.714039,
      1.772134,
      0.977219,
      2.081451,
      0,
      2,
      3.320545,
      0.386346,
      1,
      1,
      3,
      0,
      4,
      1.001598,
      0.585166,
      3.652251,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836094,
      NULL,
      NULL,
      5,
      1.254735,
      1.526504,
      2.812089,
      2,
      1.387594,
      0.491375,
      NULL,
      1.880386,
      1.042742,
      1.956530,
      0,
      0.004961,
      1.678377,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      1.510074,
      NULL,
      1.684183,
      5.341116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.855113,
      2,
      NULL,
      0,
      NULL,
      5.614990,
      NULL,
      NULL,
      NULL,
      0.268742,
      NULL,
      3.428762,
      2.514544,
      1,
      0.673525,
      NULL,
      NULL,
      1,
      1.159291,
      6.361157,
      1.517682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513859,
      0.908340,
      NULL,
      0,
      0.152644,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425458,
      NULL,
      8.101721,
      2.993029,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142177,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0.033020,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129465,
      NULL,
      2,
      2,
      NULL,
      NULL,
      0,
      0,
      1.844813,
      2,
      1.604039,
      1.504969,
      0,
      1,
      1.348715,
      1.775483,
      1,
      0.053393,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.303672,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.827687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041188,
      0,
      NULL,
      0.456864,
      0,
      1.449355,
      1,
      3.933361,
      '11023',
      '',
      '',
      0.946489,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      4.978157,
      NULL,
      0,
      1,
      0.627538,
      1,
      NULL,
      NULL);
commit;
end;
/


