set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44213223',
      24,
      3,
      '2401224',
      NULL,
      0,
      2.417099,
      2,
      '414243',
      4.908539,
      ' 4-11-1992',
      40.186673,
      10,
      NULL,
      NULL,
      0.921421,
      1,
      3.829803,
      0,
      NULL,
      NULL,
      1.815972,
      1.868589,
      0,
      0,
      0.216735,
      0.450276,
      NULL,
      1.453634,
      0,
      3,
      0.022140,
      1,
      4,
      5,
      2,
      5,
      0,
      0,
      3,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.338541,
      NULL,
      NULL,
      5,
      0.683004,
      NULL,
      1,
      0.369421,
      NULL,
      3.444536,
      0.098676,
      0.241952,
      0,
      3.333670,
      0,
      NULL,
      3,
      NULL,
      1,
      0,
      2.675657,
      NULL,
      NULL,
      0.020134,
      0.489862,
      4,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.662503,
      0.307252,
      3.017431,
      1,
      NULL,
      1,
      1.979500,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0.287395,
      NULL,
      0.473087,
      1.429562,
      NULL,
      0.929093,
      0.750437,
      0.660187,
      NULL,
      1,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530820,
      NULL,
      2,
      1.067042,
      1.105309,
      4.603860,
      2,
      0.672729,
      4.105522,
      1.686968,
      NULL,
      1.032066,
      0,
      0,
      1.214090,
      1,
      3,
      1.862853,
      0.311630,
      9.081903,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0.762676,
      0.857816,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.494261,
      NULL,
      8.574739,
      0,
      3.446828,
      3.242544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.939589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937875,
      1,
      1.517600,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      3,
      1.441678,
      NULL,
      0,
      0.331582,
      0.389049,
      1.576278,
      1,
      0.724005,
      1,
      1.933649,
      NULL,
      0,
      0.780140,
      1,
      0,
      1.823922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.989230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392761,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      1.670537,
      1.434881,
      1,
      1.435530,
      '22111',
      '',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      3,
      1.789791,
      NULL,
      0,
      1.822810,
      0);
commit;
end;
/


