set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1414',
      NULL,
      21.286756,
      NULL,
      '4133100',
      45.996162,
      5,
      2.470683,
      NULL,
      NULL,
      NULL,
      ' 1-26-2001',
      NULL,
      2,
      NULL,
      NULL,
      0.539147,
      1,
      1.016899,
      0,
      NULL,
      0,
      0,
      2.805918,
      NULL,
      2.168625,
      4.918740,
      NULL,
      0,
      5.833233,
      1,
      1,
      3,
      NULL,
      4.283025,
      5.053124,
      0,
      1,
      3,
      1,
      0,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.246612,
      1.776217,
      2,
      2.583862,
      NULL,
      NULL,
      NULL,
      0.667916,
      0,
      3,
      1.167585,
      0.725570,
      3.713273,
      3,
      0,
      1.180511,
      1,
      1,
      1,
      1,
      0,
      0,
      3.795501,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.800514,
      0,
      0.945233,
      NULL,
      3.451469,
      1.026804,
      0.727595,
      0,
      NULL,
      1.847881,
      NULL,
      0.055197,
      0.541437,
      0.319175,
      1.995391,
      0.389703,
      0,
      0,
      0.009677,
      NULL,
      1.174990,
      3.583406,
      1.078929,
      1,
      1,
      1.290874,
      1,
      1,
      1,
      0.979250,
      0.081431,
      0,
      1.289356,
      0.298680,
      1.814499,
      1,
      0,
      1,
      4,
      5,
      3.647019,
      1.728056,
      4.686488,
      5,
      3,
      0.933920,
      NULL,
      0,
      NULL,
      NULL,
      1,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066277,
      1.197354,
      2,
      NULL,
      1.613513,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.997830,
      1.538893,
      NULL,
      1.563317,
      1,
      0,
      0.053373,
      NULL,
      NULL,
      NULL,
      NULL,
      0.377130,
      0.999966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.495499,
      0.275744,
      NULL,
      0,
      NULL,
      0,
      1,
      1.522550,
      NULL,
      0.533019,
      1,
      0,
      NULL,
      0.045051,
      NULL,
      1.285542,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860867,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512000,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.840997,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      '00424',
      '',
      '',
      0,
      '',
      '',
      '',
      0.971918,
      '',
      '',
      '',
      1.229955,
      NULL,
      4,
      2,
      0.484762,
      NULL,
      2.739525,
      0,
      2.701272);
commit;
end;
/


