set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9841090';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4310',
      NULL,
      42.004075,
      NULL,
      NULL,
      59.465434,
      2,
      NULL,
      0,
      '312022',
      0,
      ' 6-12-1976',
      21.576535,
      30.192123,
      0,
      NULL,
      1,
      3,
      0,
      0.324463,
      1.152080,
      1.200759,
      NULL,
      1,
      0,
      0.434580,
      0.574680,
      NULL,
      1,
      3,
      NULL,
      0.810701,
      3.671868,
      1.570573,
      2,
      1,
      3.259806,
      NULL,
      1,
      NULL,
      1.465825,
      NULL,
      3.826137,
      0.240240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.380679,
      1.690936,
      1.690934,
      0,
      3.150219,
      2.831262,
      0,
      0.261364,
      0,
      0,
      1.509637,
      0,
      3.186849,
      3.840433,
      NULL,
      NULL,
      2.631363,
      0.178815,
      1,
      1,
      2.405139,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.581474,
      2.173636,
      NULL,
      1.630352,
      1,
      0,
      0.317570,
      0.025593,
      NULL,
      0,
      0.824737,
      0.511335,
      1.364262,
      1.127300,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.387024,
      0,
      1,
      0,
      NULL,
      NULL,
      0.673497,
      NULL,
      1,
      NULL,
      0.155577,
      NULL,
      0.011389,
      NULL,
      NULL,
      1.082393,
      NULL,
      NULL,
      0,
      0,
      4.389038,
      0.694621,
      4,
      1.328640,
      NULL,
      1,
      NULL,
      1.470857,
      0.944209,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378104,
      0,
      0,
      0.030680,
      0,
      0.542986,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1.492221,
      2,
      1.195664,
      0,
      0.913376,
      4.397408,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.693875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.280831,
      3.826376,
      3.440480,
      3,
      1.707817,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0.087520,
      0.937115,
      NULL,
      1,
      1,
      0.600284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.678771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.612778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075872,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.183874,
      0,
      NULL,
      1.090575,
      1.326970,
      NULL,
      2,
      NULL,
      '42121',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      1.323518,
      '',
      '',
      '',
      3.416400,
      3,
      3.982986,
      3,
      NULL,
      3.222887,
      2,
      NULL,
      1);
commit;
end;
/


